import java.awt.Color;
import java.awt.Graphics;

public class Grid extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeMovedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeSelectedByUser()
	{
		return false;
	};
	// end of DrawObject abilities

	@Override
	public void Draw(Graphics g)
	{
		// grid lines x/y distance hard-coded to 50 pixels, all objects are aligned to this raster

		SetColor(g, Color.LIGHT_GRAY);
		int LineIndexyp = 0;
		int LineIndexyn = 0;
		while (true)
		{
			int y = DrawObject.ZoomPointY(LineIndexyp * 50);
			if (y > MainWindow.MainWindowSizeY)
				break;
			g.drawLine(0, y, MainWindow.MainWindowSizeX, y); // DO NOT use DrawLine(), because it does "normal" zooming, but we zoomed already (see above)
			LineIndexyp++;
		}
		while (true)
		{
			int y = DrawObject.ZoomPointY(LineIndexyn * 50);
			if (y < 0)
				break;
			g.drawLine(0, y, MainWindow.MainWindowSizeX, y); // DO NOT use DrawLine(), because it does "normal" zooming, but we zoomed already (see above)
			LineIndexyn--;
		}
		int LineIndexxp = 0;
		int LineIndexxn = 0;
		while (true)
		{
			int x = DrawObject.ZoomPointX(LineIndexxp * 50);
			if (x > MainWindow.MainWindowSizeX)
				break;
			g.drawLine(x, 0, x, MainWindow.MainWindowSizeY); // DO NOT use DrawLine(), because it does "normal" zooming, but we zoomed already (see above)
			LineIndexxp++;
		}
		while (true)
		{
			int x = DrawObject.ZoomPointX(LineIndexxn * 50);
			if (x < 0)
				break;
			g.drawLine(x, 0, x, MainWindow.MainWindowSizeY); // DO NOT use DrawLine(), because it does "normal" zooming, but we zoomed already (see above)
			LineIndexxn--;
		}
	}
}
